local STEM_WIDTH_FRACTION = 1/3

HorizontalArrowStamp = function(canvas, y, x1, x2, width, paint)
    if math.abs(x2 - x1) < 1 then
        local x = (x1 + x2) / 2
        local path = Path.line{x1 = x, y1 = y - width, x2 = x, y2 = y + width}
        canvas:setPaint(paint)
            :setThickness(1)
            :stroke(path)
    else
        local headLength
        if x1 < x2 then
            headLength = math.min(width, x2 - x1)
        else
            headLength = math.max(-width, x2 - x1)
        end
        local path = Path.point{x = x2, y = y}
            :addLine{x = x2 - headLength, y = y - width}
            :addLine{x = x2 - headLength, y = y - width * STEM_WIDTH_FRACTION}
            :addLine{x = x1, y = y - width * STEM_WIDTH_FRACTION}
            :addLine{x = x1, y = y + width * STEM_WIDTH_FRACTION}
            :addLine{x = x2 - headLength, y = y + width * STEM_WIDTH_FRACTION}
            :addLine{x = x2 - headLength, y = y + width}
            :closeSubpath()
        canvas:setPaint(paint):fill(path)
    end
end

return HorizontalArrowStamp
